import UPNG from 'upng-js';
/**
 * Icon object.
 */
export class Icon {
  /**
   * Icon constructor.
   */
  constructor() {}

  /**
   * Decode PNG data to RGBA image.
   *
   * @param data PNG data.
   * @returns Image data.
   */
  _decodePngToRgba(data) {
    const image = UPNG.decode(data);
    return {
      width: image.width,
      height: image.height,
      data: new Uint8Array(UPNG.toRGBA8(image)[0])
    };
  }

  /**
   * Encode RGBA image to PNG data.
   *
   * @param imageData Image data.
   * @returns PNG data.
   */
  _encodeRgbaToPng(imageData) {
    return Buffer.from(UPNG.encode([imageData.data.buffer], imageData.width, imageData.height, 0, [], true));
  }

  /**
   * Encode icon.
   *
   * @returns Encoded icon.
   */
}
//# sourceMappingURL=icon.mjs.map
