/* SPDX-License-Identifier: (GPL-2.0+ OR MIT) */
/*
 * Copyright (c) 2019 Amlogic, Inc. All rights reserved.
 */

#ifndef __S5_CLKC_H
#define __S5_CLKC_H

/*
 * CLKID index values
 */
#define CLKID_SYS_PLL_DCO		0
#define CLKID_SYS_PLL			1
#define CLKID_SYS1_PLL_DCO		2
#define CLKID_SYS1_PLL			3
#define CLKID_FIXED_PLL_DCO		4
#define CLKID_FIXED_PLL			5
#define CLKID_FCLK_DIV2_DIV		6
#define CLKID_FCLK_DIV2			7
#define CLKID_FCLK_DIV3_DIV		8
#define CLKID_FCLK_DIV3			9
#define CLKID_FCLK_DIV4_DIV		10
#define CLKID_FCLK_DIV4			11
#define CLKID_FCLK_DIV5_DIV		12
#define CLKID_FCLK_DIV5			13
#define CLKID_FCLK_DIV7_DIV		14
#define CLKID_FCLK_DIV7			15
#define CLKID_FCLK_DIV2P5_DIV		16
#define CLKID_FCLK_DIV2P5		17
#define CLKID_FCLK_CLK50M_DIV		18
#define CLKID_FCLK_CLK50M		19
#define CLKID_GP0_PLL_DCO		20
#define CLKID_GP0_PLL			21
#define CLKID_GP1_PLL_DCO		22
#define CLKID_GP1_PLL			23
#define CLKID_CPU_DYN_CLK		24
#define CLKID_CPU_CLK			25
#define CLKID_HIFI_PLL_DCO		26
#define CLKID_HIFI_PLL			27
#define CLKID_PCIE_PLL_DCO		28
#define CLKID_PCIE_PLL_DCO_DIV2		29
#define CLKID_PCIE_PLL_OD		30
#define CLKID_PCIE_PLL			31
#define CLKID_PCIE_BGP			32
#define CLKID_PCIE_HCSL_OUT		33
#define CLKID_PCIE_HCSL_PAD		34
#define CLKID_PCIE_HCSL_IN_PAD		35
#define CLKID_PCIE_CLK_IN		36
#define CLKID_PCIE1_PLL_DCO		37
#define CLKID_PCIE1_PLL_DCO_DIV2	38
#define CLKID_PCIE1_PLL_OD		39
#define CLKID_PCIE1_PLL			40
#define CLKID_PCIE1_BGP			41
#define CLKID_PCIE1_HCSL_OUT		42
#define CLKID_PCIE1_HCSL_PAD		43
#define CLKID_PCIE1_HCSL_IN_PAD		44
#define CLKID_PCIE1_CLK_IN		45
#define CLKID_SYS2_PLL_DCO		46
#define CLKID_SYS2_PLL			47
#define CLKID_A76_DYN_CLK		48
#define CLKID_A76_CLK			49
#define CLKID_DSU_DYN_CLK		50
#define CLKID_DSU_CLK			51
#define CLKID_DSU_FINAL_CLK		52
#define CLKID_GP2_PLL_DCO		53
#define CLKID_GP2_PLL			54
#define CLKID_NNA_PLL_DCO		55
#define CLKID_NNA_PLL			56
#define CLKID_NNA_PLL_AUDIO		57
#define CLKID_HIFI1_PLL_DCO		58
#define CLKID_HIFI1_PLL			59
#define CLKID_FDLE_PLL_DCO		60
#define CLKID_FDLE_PLL_OD		61
#define CLKID_FDLE_PLL_OD1		62
#define CLKID_FDLE_PLL_TMDS		63
#define CLKID_FDLE_PLL_PIXEL		64
#define CLKID_CPU4_CLK			65

#define CLKID_BASE			66
#define CLKID_RTC_32K_CLKIN		(CLKID_BASE + 0)
#define CLKID_RTC_32K_DIV		(CLKID_BASE + 1)
#define CLKID_RTC_32K_XATL		(CLKID_BASE + 2)
#define CLKID_RTC_32K_SEL		(CLKID_BASE + 3)
#define CLKID_RTC_CLK			(CLKID_BASE + 4)
#define CLKID_SYS_CLK_1_SEL		(CLKID_BASE + 5)
#define CLKID_SYS_CLK_1_DIV		(CLKID_BASE + 6)
#define CLKID_SYS_CLK_1			(CLKID_BASE + 7)
#define CLKID_SYS_CLK_0_SEL		(CLKID_BASE + 8)
#define CLKID_SYS_CLK_0_DIV		(CLKID_BASE + 9)
#define CLKID_SYS_CLK_0			(CLKID_BASE + 10)
#define CLKID_SYS_CLK			(CLKID_BASE + 11)
#define CLKID_CECA_32K_CLKIN		(CLKID_BASE + 12)
#define CLKID_CECA_32K_DIV		(CLKID_BASE + 13)
#define CLKID_CECA_32K_MUX_PRE		(CLKID_BASE + 14)
#define CLKID_CECA_32K_MUX		(CLKID_BASE + 15)
#define CLKID_CECA_32K_CLKOUT		(CLKID_BASE + 16)
#define CLKID_CECB_32K_CLKIN		(CLKID_BASE + 17)
#define CLKID_CECB_32K_DIV		(CLKID_BASE + 18)
#define CLKID_CECB_32K_MUX_PRE		(CLKID_BASE + 19)
#define CLKID_CECB_32K_MUX		(CLKID_BASE + 20)
#define CLKID_CECB_32K_CLKOUT		(CLKID_BASE + 21)
#define CLKID_AXICLK_1_SEL		(CLKID_BASE + 22)
#define CLKID_AXICLK_1_DIV		(CLKID_BASE + 23)
#define CLKID_AXICLK_1			(CLKID_BASE + 24)
#define CLKID_AXICLK_0_SEL		(CLKID_BASE + 25)
#define CLKID_AXICLK_0_DIV		(CLKID_BASE + 26)
#define CLKID_AXICLK_0			(CLKID_BASE + 27)
#define CLKID_AXICLK			(CLKID_BASE + 28)
#define CLKID_24M_CLK_GATE		(CLKID_BASE + 29)
#define CLKID_24M_DIV2			(CLKID_BASE + 30)
#define CLKID_12M_CLK			(CLKID_BASE + 31)
#define CLKID_25M_CLK_DIV		(CLKID_BASE + 32)
#define CLKID_25M_CLK			(CLKID_BASE + 33)

#define VIDEO_BASE			(CLKID_BASE + 34)
#define CLKID_VCLK_SEL			(VIDEO_BASE + 0)
#define CLKID_VCLK2_SEL			(VIDEO_BASE + 1)
#define CLKID_VCLK_INPUT		(VIDEO_BASE + 2)
#define CLKID_VCLK2_INPUT		(VIDEO_BASE + 3)
#define CLKID_VCLK_DIV			(VIDEO_BASE + 4)
#define CLKID_VCLK2_DIV			(VIDEO_BASE + 5)
#define CLKID_VCLK			(VIDEO_BASE + 6)
#define CLKID_VCLK2			(VIDEO_BASE + 7)
#define CLKID_VCLK_DIV1			(VIDEO_BASE + 8)
#define CLKID_VCLK_DIV2_EN		(VIDEO_BASE + 9)
#define CLKID_VCLK_DIV4_EN		(VIDEO_BASE + 10)
#define CLKID_VCLK_DIV6_EN		(VIDEO_BASE + 11)
#define CLKID_VCLK_DIV12_EN		(VIDEO_BASE + 12)
#define CLKID_VCLK2_DIV1		(VIDEO_BASE + 13)
#define CLKID_VCLK2_DIV2_EN		(VIDEO_BASE + 14)
#define CLKID_VCLK2_DIV4_EN		(VIDEO_BASE + 15)
#define CLKID_VCLK2_DIV6_EN		(VIDEO_BASE + 16)
#define CLKID_VCLK2_DIV12_EN		(VIDEO_BASE + 17)
#define CLKID_VCLK_DIV2			(VIDEO_BASE + 18)
#define CLKID_VCLK_DIV4			(VIDEO_BASE + 19)
#define CLKID_VCLK_DIV6			(VIDEO_BASE + 20)
#define CLKID_VCLK_DIV12		(VIDEO_BASE + 21)
#define CLKID_VCLK2_DIV2		(VIDEO_BASE + 22)
#define CLKID_VCLK2_DIV4		(VIDEO_BASE + 23)
#define CLKID_VCLK2_DIV6		(VIDEO_BASE + 24)
#define CLKID_VCLK2_DIV12		(VIDEO_BASE + 25)
#define CLKID_CTS_ENCI_SEL		(VIDEO_BASE + 26)
#define CLKID_CTS_ENCT_SEL		(VIDEO_BASE + 28)
#define CLKID_CTS_ENCP_SEL		(VIDEO_BASE + 29)
#define CLKID_CTS_ENCL_SEL		(VIDEO_BASE + 30)
#define CLKID_CTS_VDAC_SEL		(VIDEO_BASE + 31)
#define CLKID_CTS_ENCI			(VIDEO_BASE + 32)
#define CLKID_CTS_ENCT			(VIDEO_BASE + 33)
#define CLKID_CTS_ENCP			(VIDEO_BASE + 34)
#define CLKID_CTS_ENCL			(VIDEO_BASE + 35)
#define CLKID_CTS_VDAC			(VIDEO_BASE + 36)

#define PERI_BASE			(VIDEO_BASE + 37)
#define CLKID_SD_EMMC_C_CLK_SEL		(PERI_BASE + 0)
#define CLKID_SD_EMMC_C_CLK_DIV		(PERI_BASE + 1)
#define CLKID_SD_EMMC_C_CLK		(PERI_BASE + 2)
#define CLKID_SD_EMMC_A_CLK_SEL		(PERI_BASE + 3)
#define CLKID_SD_EMMC_A_CLK_DIV		(PERI_BASE + 4)
#define CLKID_SD_EMMC_A_CLK		(PERI_BASE + 5)
#define CLKID_SD_EMMC_B_CLK_SEL		(PERI_BASE + 6)
#define CLKID_SD_EMMC_B_CLK_DIV		(PERI_BASE + 7)
#define CLKID_SD_EMMC_B_CLK		(PERI_BASE + 8)
#define CLKID_SPICC0_SEL		(PERI_BASE + 9)
#define CLKID_SPICC0_DIV		(PERI_BASE + 10)
#define CLKID_SPICC0			(PERI_BASE + 11)
#define CLKID_SPICC1_SEL		(PERI_BASE + 12)
#define CLKID_SPICC1_DIV		(PERI_BASE + 13)
#define CLKID_SPICC1			(PERI_BASE + 14)
#define CLKID_SPICC2_SEL		(PERI_BASE + 15)
#define CLKID_SPICC2_DIV		(PERI_BASE + 16)
#define CLKID_SPICC2			(PERI_BASE + 17)
#define CLKID_PWM_A_SEL			(PERI_BASE + 27)
#define CLKID_PWM_A_DIV			(PERI_BASE + 28)
#define CLKID_PWM_A			(PERI_BASE + 29)
#define CLKID_PWM_B_SEL			(PERI_BASE + 30)
#define CLKID_PWM_B_DIV			(PERI_BASE + 31)
#define CLKID_PWM_B			(PERI_BASE + 32)
#define CLKID_PWM_C_SEL			(PERI_BASE + 33)
#define CLKID_PWM_C_DIV			(PERI_BASE + 34)
#define CLKID_PWM_C			(PERI_BASE + 35)
#define CLKID_PWM_D_SEL			(PERI_BASE + 36)
#define CLKID_PWM_D_DIV			(PERI_BASE + 37)
#define CLKID_PWM_D			(PERI_BASE + 38)
#define CLKID_PWM_E_SEL			(PERI_BASE + 39)
#define CLKID_PWM_E_DIV			(PERI_BASE + 40)
#define CLKID_PWM_E			(PERI_BASE + 41)
#define CLKID_PWM_F_SEL			(PERI_BASE + 42)
#define CLKID_PWM_F_DIV			(PERI_BASE + 43)
#define CLKID_PWM_F			(PERI_BASE + 44)
#define CLKID_PWM_G_SEL			(PERI_BASE + 45)
#define CLKID_PWM_G_DIV			(PERI_BASE + 46)
#define CLKID_PWM_G			(PERI_BASE + 47)
#define CLKID_PWM_H_SEL			(PERI_BASE + 48)
#define CLKID_PWM_H_DIV			(PERI_BASE + 49)
#define CLKID_PWM_H			(PERI_BASE + 50)
#define CLKID_PWM_I_SEL			(PERI_BASE + 51)
#define CLKID_PWM_I_DIV			(PERI_BASE + 52)
#define CLKID_PWM_I			(PERI_BASE + 53)
#define CLKID_PWM_J_SEL			(PERI_BASE + 54)
#define CLKID_PWM_J_DIV			(PERI_BASE + 55)
#define CLKID_PWM_J			(PERI_BASE + 56)
#define CLKID_SARADC_SEL		(PERI_BASE + 57)
#define CLKID_SARADC_DIV		(PERI_BASE + 58)
#define CLKID_SARADC			(PERI_BASE + 59)
#define CLKID_GEN_SEL			(PERI_BASE + 60)
#define CLKID_GEN_DIV			(PERI_BASE + 61)
#define CLKID_GEN			(PERI_BASE + 62)
#define CLKID_ETH_RMII_SEL		(PERI_BASE + 63)
#define CLKID_ETH_RMII_DIV		(PERI_BASE + 64)
#define CLKID_ETH_RMII			(PERI_BASE + 65)
#define CLKID_ETH_DIV8			(PERI_BASE + 66)
#define CLKID_ETH_125M			(PERI_BASE + 67)
#define CLKID_TS_CLK_DIV		(PERI_BASE + 68)
#define CLKID_TS_CLK			(PERI_BASE + 69)
#define CLKID_USB_250M_SEL		(PERI_BASE + 70)
#define CLKID_USB_250M_DIV		(PERI_BASE + 71)
#define CLKID_USB_250M			(PERI_BASE + 72)
#define CLKID_PCIE_400M_SEL		(PERI_BASE + 73)
#define CLKID_PCIE_400M_DIV		(PERI_BASE + 74)
#define CLKID_PCIE_400M			(PERI_BASE + 75)
#define CLKID_PCIE_CLK_SEL		(PERI_BASE + 76)
#define CLKID_PCIE_CLK_DIV		(PERI_BASE + 77)
#define CLKID_PCIE_CLK			(PERI_BASE + 78)
#define CLKID_PCIE_TL_CLK_SEL		(PERI_BASE + 79)
#define CLKID_PCIE_TL_CLK_DIV		(PERI_BASE + 80)
#define CLKID_PCIE_TL_CLK		(PERI_BASE + 81)
#define CLKID_CDAC_SEL			(PERI_BASE + 82)
#define CLKID_CDAC_DIV			(PERI_BASE + 83)
#define CLKID_CDAC			(PERI_BASE + 84)
#define CLKID_SC_SEL			(PERI_BASE + 85)
#define CLKID_SC_DIV			(PERI_BASE + 86)
#define CLKID_SC			(PERI_BASE + 87)

#define MEDIA_BASE			(PERI_BASE + 88)
#define CLKID_VAPB_0_SEL		(MEDIA_BASE + 1)
#define CLKID_VAPB_0_DIV		(MEDIA_BASE + 2)
#define CLKID_VAPB_0			(MEDIA_BASE + 3)
#define CLKID_GE2D_SEL			(MEDIA_BASE + 4)
#define CLKID_GE2D_DIV			(MEDIA_BASE + 5)
#define CLKID_GE2D			(MEDIA_BASE + 6)
#define CLKID_NNA_0_SEL			(MEDIA_BASE + 7)
#define CLKID_NNA_0_DIV			(MEDIA_BASE + 8)
#define CLKID_NNA_0			(MEDIA_BASE + 9)
#define CLKID_NNA_1_SEL			(MEDIA_BASE + 10)
#define CLKID_NNA_1_DIV			(MEDIA_BASE + 11)
#define CLKID_NNA_1			(MEDIA_BASE + 12)
#define CLKID_NNA			(MEDIA_BASE + 14)
#define CLKID_VPU0_SEL			(MEDIA_BASE + 15)
#define CLKID_VPU0_DIV			(MEDIA_BASE + 16)
#define CLKID_VPU0			(MEDIA_BASE + 17)
#define CLKID_VPU1_SEL			(MEDIA_BASE + 18)
#define CLKID_VPU1_DIV			(MEDIA_BASE + 19)
#define CLKID_VPU1			(MEDIA_BASE + 20)
#define CLKID_VPU			(MEDIA_BASE + 21)
#define CLKID_VPU_CLKB_TMP_SEL		(MEDIA_BASE + 22)
#define CLKID_VPU_CLKB_TMP_DIV		(MEDIA_BASE + 23)
#define CLKID_VPU_CLKB_TMP		(MEDIA_BASE + 24)
#define CLKID_VPU_CLKB_DIV		(MEDIA_BASE + 25)
#define CLKID_VPU_CLKB			(MEDIA_BASE + 26)
#define CLKID_VIN_MEAS_SEL		(MEDIA_BASE + 27)
#define CLKID_VIN_MEAS_DIV		(MEDIA_BASE + 28)
#define CLKID_VIN_MEAS			(MEDIA_BASE + 29)
#define CLKID_VID_LOCK_SEL		(MEDIA_BASE + 30)
#define CLKID_VID_LOCK_DIV		(MEDIA_BASE + 31)
#define CLKID_VID_LOCK			(MEDIA_BASE + 32)
#define CLKID_CMPR_SEL			(MEDIA_BASE + 33)
#define CLKID_CMPR_DIV			(MEDIA_BASE + 34)
#define CLKID_CMPR			(MEDIA_BASE + 35)
#define CLKID_MALI0_SEL			(MEDIA_BASE + 36)
#define CLKID_MALI0_DIV			(MEDIA_BASE + 37)
#define CLKID_MALI0			(MEDIA_BASE + 38)
#define CLKID_MALI1_SEL			(MEDIA_BASE + 39)
#define CLKID_MALI1_DIV			(MEDIA_BASE + 40)
#define CLKID_MALI1			(MEDIA_BASE + 41)
#define CLKID_MALI			(MEDIA_BASE + 42)
#define CLKID_VDEC0_SEL			(MEDIA_BASE + 43)
#define CLKID_VDEC0_DIV			(MEDIA_BASE + 44)
#define CLKID_VDEC0			(MEDIA_BASE + 45)
#define CLKID_VDEC1_SEL			(MEDIA_BASE + 46)
#define CLKID_VDEC1_DIV			(MEDIA_BASE + 47)
#define CLKID_VDEC1			(MEDIA_BASE + 48)
#define CLKID_VDEC			(MEDIA_BASE + 49)
#define CLKID_HCODEC0_SEL		(MEDIA_BASE + 50)
#define CLKID_HCODEC0_DIV		(MEDIA_BASE + 51)
#define CLKID_HCODEC0			(MEDIA_BASE + 52)
#define CLKID_HCODEC1_SEL		(MEDIA_BASE + 53)
#define CLKID_HCODEC1_DIV		(MEDIA_BASE + 54)
#define CLKID_HCODEC1			(MEDIA_BASE + 55)
#define CLKID_HCODEC			(MEDIA_BASE + 56)
#define CLKID_HEVC0_SEL			(MEDIA_BASE + 57)
#define CLKID_HEVC0_DIV			(MEDIA_BASE + 58)
#define CLKID_HEVC0			(MEDIA_BASE + 59)
#define CLKID_HEVC1_SEL			(MEDIA_BASE + 60)
#define CLKID_HEVC1_DIV			(MEDIA_BASE + 61)
#define CLKID_HEVC1			(MEDIA_BASE + 62)
#define CLKID_HEVC			(MEDIA_BASE + 63)
#define CLKID_VC9000E_AXI_SEL		(MEDIA_BASE + 64)
#define CLKID_VC9000E_AXI_DIV		(MEDIA_BASE + 65)
#define CLKID_VC9000E_AXI		(MEDIA_BASE + 66)
#define CLKID_VC9000E_CORE_SEL		(MEDIA_BASE + 67)
#define CLKID_VC9000E_CORE_DIV		(MEDIA_BASE + 68)
#define CLKID_VC9000E_CORE		(MEDIA_BASE + 69)
#define CLKID_HDMITX_SYS_SEL		(MEDIA_BASE + 70)
#define CLKID_HDMITX_SYS_DIV		(MEDIA_BASE + 71)
#define CLKID_HDMITX_SYS		(MEDIA_BASE + 72)
#define CLKID_HDMITX_PRIF_SEL		(MEDIA_BASE + 73)
#define CLKID_HDMITX_PRIF_DIV		(MEDIA_BASE + 74)
#define CLKID_HDMITX_PRIF		(MEDIA_BASE + 75)
#define CLKID_HDMITX_200M_SEL		(MEDIA_BASE + 76)
#define CLKID_HDMITX_200M_DIV		(MEDIA_BASE + 77)
#define CLKID_HDMITX_200M		(MEDIA_BASE + 78)
#define CLKID_HDMITX_AUD_SEL		(MEDIA_BASE + 79)
#define CLKID_HDMITX_AUD_DIV		(MEDIA_BASE + 80)
#define CLKID_HDMITX_AUD		(MEDIA_BASE + 81)
#define CLKID_ENC_HDMI_TX_PNX_SEL	(MEDIA_BASE + 82)
#define CLKID_ENC_HDMI_TX_PNX		(MEDIA_BASE + 83)
#define CLKID_ENC_HDMI_TX_FE_SEL	(MEDIA_BASE + 84)
#define CLKID_ENC_HDMI_TX_FE		(MEDIA_BASE + 85)
#define CLKID_ENC_HDMI_TX_PIXEL_SEL	(MEDIA_BASE + 86)
#define CLKID_ENC_HDMI_TX_PIXEL		(MEDIA_BASE + 87)
#define CLKID_HDMI_TX_PNX_SEL		(MEDIA_BASE + 88)
#define CLKID_HDMI_TX_FE_SEL		(MEDIA_BASE + 89)
#define CLKID_HDMI_TX_PIXEL_SEL		(MEDIA_BASE + 90)
#define CLKID_HDMI_TX_PNX_DIV		(MEDIA_BASE + 91)
#define CLKID_HDMI_TX_FE_DIV		(MEDIA_BASE + 92)
#define CLKID_HDMI_TX_PIXEL_DIV		(MEDIA_BASE + 93)
#define CLKID_HDMI_TX_PNX		(MEDIA_BASE + 94)
#define CLKID_HDMI_TX_FE		(MEDIA_BASE + 95)
#define CLKID_HDMI_TX_PIXEL		(MEDIA_BASE + 96)
#define CLKID_HTX_TMDS_SEL		(MEDIA_BASE + 97)
#define CLKID_HTX_TMDS_DIV		(MEDIA_BASE + 98)
#define CLKID_HTX_TMDS			(MEDIA_BASE + 99)

#define SYS_BASE			(MEDIA_BASE + 100)
#define CLKID_SYS_CLK_DDR		(SYS_BASE + 0)
#define CLKID_SYS_CLK_ETHPHY		(SYS_BASE + 1)
#define CLKID_SYS_CLK_GPU		(SYS_BASE + 2)
#define CLKID_SYS_CLK_VC9000E		(SYS_BASE + 3)
#define CLKID_SYS_CLK_AOCPU		(SYS_BASE + 4)
#define CLKID_SYS_CLK_AUCPU		(SYS_BASE + 5)
#define CLKID_SYS_CLK_DEWARPC		(SYS_BASE + 6)
#define CLKID_SYS_CLK_DEWARPB		(SYS_BASE + 7)
#define CLKID_SYS_CLK_DEWARPA		(SYS_BASE + 8)
#define CLKID_SYS_CLK_AMPIPE_NAND	(SYS_BASE + 9)
#define CLKID_SYS_CLK_AMPIPE_ETH	(SYS_BASE + 10)
#define CLKID_SYS_CLK_AM2AXI0		(SYS_BASE + 11)
#define CLKID_SYS_CLK_IR_CTRL		(SYS_BASE + 12)
#define CLKID_SYS_CLK_SD_EMMC_B		(SYS_BASE + 13)
#define CLKID_SYS_CLK_SD_EMMC_A		(SYS_BASE + 14)
#define CLKID_SYS_CLK_SD_EMMC_C		(SYS_BASE + 15)
#define CLKID_SYS_CLK_SPIFC		(SYS_BASE + 16)
#define CLKID_SYS_CLK_MSR_CLK		(SYS_BASE + 17)
#define CLKID_SYS_CLK_AUDIO		(SYS_BASE + 18)
#define CLKID_SYS_CLK_ETH		(SYS_BASE + 19)
#define CLKID_SYS_CLK_UART_A		(SYS_BASE + 20)
#define CLKID_SYS_CLK_UART_B		(SYS_BASE + 21)
#define CLKID_SYS_CLK_UART_C		(SYS_BASE + 22)
#define CLKID_SYS_CLK_UART_D		(SYS_BASE + 23)
#define CLKID_SYS_CLK_UART_E		(SYS_BASE + 24)
#define CLKID_SYS_CLK_UART_F		(SYS_BASE + 25)
#define CLKID_SYS_CLK_DOS		(SYS_BASE + 26)
#define CLKID_SYS_CLK_SPICC2		(SYS_BASE + 27)
#define CLKID_SYS_CLK_ACODEC		(SYS_BASE + 28)
#define CLKID_SYS_CLK_TS_A55		(SYS_BASE + 29)
#define CLKID_SYS_CLK_SMART_CARD	(SYS_BASE + 30)
#define CLKID_SYS_CLK_G2D		(SYS_BASE + 31)
#define CLKID_SYS_CLK_SPICC0		(SYS_BASE + 32)
#define CLKID_SYS_CLK_SPICC1		(SYS_BASE + 33)
#define CLKID_SYS_CLK_PCIE		(SYS_BASE + 34)
#define CLKID_SYS_CLK_PCIEPHY		(SYS_BASE + 35)
#define CLKID_SYS_CLK_USB		(SYS_BASE + 36)
#define CLKID_SYS_CLK_PCIE_PHY0		(SYS_BASE + 37)
#define CLKID_SYS_CLK_PCIE_PHY1		(SYS_BASE + 38)
#define CLKID_SYS_CLK_PCIE_PHY2		(SYS_BASE + 39)
#define CLKID_SYS_CLK_I2C_M_A		(SYS_BASE + 40)
#define CLKID_SYS_CLK_I2C_M_B		(SYS_BASE + 41)
#define CLKID_SYS_CLK_I2C_M_C		(SYS_BASE + 42)
#define CLKID_SYS_CLK_I2C_M_D		(SYS_BASE + 43)
#define CLKID_SYS_CLK_I2C_M_E		(SYS_BASE + 44)
#define CLKID_SYS_CLK_I2C_M_F		(SYS_BASE + 45)
#define CLKID_SYS_CLK_TS_GPU		(SYS_BASE + 46)
#define CLKID_SYS_CLK_I2C_S_A		(SYS_BASE + 47)
#define CLKID_SYS_CLK_CMPR		(SYS_BASE + 48)
#define CLKID_SYS_CLK_MMC_PCLK		(SYS_BASE + 49)
#define CLKID_SYS_CLK_HDMITX_PCLK	(SYS_BASE + 50)
#define CLKID_SYS_CLK_HDMI20_AES_CLK	(SYS_BASE + 51)
#define CLKID_SYS_CLK_PCLK_SYS_CPU_APB	(SYS_BASE + 52)
#define CLKID_SYS_CLK_CEC		(SYS_BASE + 53)
#define CLKID_SYS_CLK_VPU_INTR		(SYS_BASE + 54)
#define CLKID_SYS_CLK_SAR_ADC		(SYS_BASE + 55)
#define CLKID_SYS_CLK_GIC		(SYS_BASE + 56)
#define CLKID_SYS_CLK_TS_NNA		(SYS_BASE + 57)
#define CLKID_SYS_CLK_PWM_AB		(SYS_BASE + 58)
#define CLKID_SYS_CLK_PWM_CD		(SYS_BASE + 59)
#define CLKID_SYS_CLK_PWM_EF		(SYS_BASE + 60)
#define CLKID_SYS_CLK_PWM_GH		(SYS_BASE + 61)
#define CLKID_SYS_CLK_PWM_IJ		(SYS_BASE + 62)
#define CLKID_SYS_CLK_TS_VPU		(SYS_BASE + 63)
#define CLKID_SYS_CLK_TS_DOS		(SYS_BASE + 64)
#define NR_CLKS				(SYS_BASE + 65)

#endif /* __S5_CLKC_H */
